<?php
/*======================================================================*\
|| #################################################################### ||
|| # [tk] Egg Avatar                                                  # ||
|| # ---------------------------------------------------------------- # ||
|| # Originally created by [tk] Software (Hamster Powered)            # ||
|| #################################################################### ||
\*======================================================================*/ 

require_once('includes/class_image.php');

class tk_Image
{
	static $instance;

	function get_instance($registry)
	{
		if ($instance)
		{
		  return $instance;
		}
		else
        {
            $postfix = ($registry->options['imagetype'] ? $registry->options['imagetype'] : 'GD');
			eval('$instance =& tk_Image_' . $postfix . '::get_instance($registry);');
			return $instance;
		}
	}
}

/**
* Abstracted tk image class
*/
class tk_Image_Abstract
{
	/**
	* Main data registry
	*
	* @var	vB_Registry
	*/
	var $registry = null;

	/**
	* Constructor
	* Don't allow direct construction of this abstract class
	* Sets registry
	*
	* @return	void
	*/
	function tk_Image_Abstract(&$registry)
	{
		if (!is_subclass_of($this, 'tk_Image_Abstract'))
		{
			trigger_error('Direct Instantiation of tk_Image_Abstract prohibited.', E_USER_ERROR);
			return NULL;
		}

		$this->registry = &$registry;
	}

	/**
	* Public functions
	*/

    function fetch_width($himage) {}
    function fetch_height($himage) {}
    function fetch_image($url) {}
    function fetch_image_from_string($string) {}
    function output($himage) {}
    function create_truecolor($imgwidth, $imgheight, $himage) {}
    function load_egg($url) {}
    function copy_image($hdst, $hsrc, $dstx, $dsty, $srcx, $srcy, $srcwidth, $srcheight) {}
    function destroy_image($himage) {}
    function process_for_output($himage) {}
}

/**
* Image class for ImageMagick
*/
class tk_Image_Magick extends tk_Image_Abstract
{
    var $vbimagemk;
    var $is_ani = false;
    static $images = array();
    
	function tk_Image_Magick(&$registry)
	{
		parent::tk_Image_Abstract($registry);
        $this->vbimagemk = new vb_Image_Magick($registry);
    }

    function get_instance($registry)
    {
        return new tk_Image_Magick($registry);
    }
    
    function check_error()
    {
        if ($error = $this->vbimagemk->fetch_error())
        {
            echo $error;
            die();
        }
    }

	/**
	* Public functions
	*/

    function fetch_width($himage) 
    {
        // determine the file size
        $args = $this->images[$himage];
        $fileinfo = $this->vbimagemk->fetch_im_exec('identify', $args, true);
        $this->check_error();        
        $fileinfo = explode(' ', $fileinfo[0]);
        $size = $fileinfo[2];
        $size = explode('x', $size);
        return $size[0];
    }
    
    function fetch_height($himage) 
    {
        // determine the file size
        $args = $this->images[$himage];
        $fileinfo = $this->vbimagemk->fetch_im_exec('identify', $args, true);
        $this->check_error();        
        $fileinfo = explode(' ', $fileinfo[0]);
        $size = $fileinfo[2];
        $size = explode('x', $size);
        return $size[1];
    }
    
    function fetch_image($url) 
    {
        $this->images[] .= $url;
        return count($this->images) - 1;
    }
    
    function fetch_image_from_string($string) 
    {
        // write a temp file
        $tmpfname = tempnam("/tmp", 'tk_');
        $handle = fopen($tmpfname, "w");
        fwrite($handle, $string);
        fclose($handle);
        
        // determine the file type
        $args = $tmpfname;
        $fileinfo = $this->vbimagemk->fetch_im_exec('identify', $args, true);
        $this->check_error();        
        $fileinfo = explode(' ', $fileinfo[0]);
        $ext = $fileinfo[1];
        
        // rename the file to add extension
        rename($tmpfname, $tmpfname . '.' . $ext);
        $this->images[] .= $tmpfname . '.' . $ext;
        return count($this->images) - 1;       
    }
    
    function output($himage) 
    {
        header('Cache-control: no-cache');
       	header('Expires: -1');
       	header('Content-disposition: inline; filename=' . $this->images[$himage]);
       	header('Content-transfer-encoding: binary');
       	$fileparts = explode(".", $this->images[$himage]);
       	header('Content-type: image/' . $fileparts[count($fileparts) - 1]);       	
        readfile($this->images[$himage]);
        $this->destroy_image($himage, false);        
    }
    
    function create_truecolor($imgwidth, $imgheight, $imgdst) 
    {
        // determine if we are dealing with an animated gif
        $info = $this->vbimagemk->fetch_im_exec('identify', $this->images[$imgdst], true);
        if (count($info) > 1)
        {
            $this->is_ani = true;
        }
        
        // get the image type
        $fileparts = explode(".", $this->images[$imgdst]);
       	$ext = $fileparts[count($fileparts) - 1];  
           
        // make a temp copy of the image to work with
        $tmpfname = tempnam("", 'tk_');
        rename($tmpfname, $tmpfname . '.' . $ext);
        $tmpfname .= '.' . $ext;
        copy($this->images[$imgdst], $tmpfname);
        
        // return the handle
        $this->images[] .= $tmpfname;
        return count($this->images) - 1;
    }

    function load_egg($url) 
    {
        $this->images[] .= $url;
        return count($this->images) - 1;
    }
    
    function copy_image($hdst, $hsrc, $dstx, $dsty, $srcx, $srcy, $srcwidth, $srcheight)
    {
        if ($this->is_ani)
        {
            $args = $this->images[$hdst];
            $args .= ' -coalesce';
            $args .= ' -draw \'image over ' . $dstx . ',' . $dsty . ',0,0 "' . $this->images[$hsrc] . '"\'';
            $args .= ' -layers Optimize ' . $this->images[$hdst];
        }
        else
        {
            $args = '-page +0+0 ' . $this->images[$hdst];
            $args .= ' -page +' . $dstx . '+' . $dsty . ' ' . $this->images[$hsrc];
            $args .= ' -background transparent';
            $args .= ' -mosaic ' . $this->images[$hdst];
        }
        $this->vbimagemk->fetch_im_exec('convert', $args);
        $this->check_error();        
    }
    
    function destroy_image($himage) 
    {
        if ($this->images[$himage])
        {
            // only destroy temp images
            if (strstr($this->images[$himage], "/tmp"))
            {
                unlink($this->images[$himage]);
            }
        }
    }
    
    function process_for_output($himage) 
    {
        // do nothing - not necessary with ImageMagick
        return $himage;
    }
}

/**
* Image class for GD Image Library
*/
class tk_Image_GD extends tk_Image_Abstract
{
	/**
	* Constructor. Sets up resizable types, extensions, etc.
	*
	* @return	void
	*/
	function tk_Image_GD(&$registry)
	{
		parent::tk_Image_Abstract($registry);
	}

    function get_instance($registry)
    {
        return new tk_Image_GD($registry);
    }
    
    /**
	* Public functions
	*/

    function fetch_width($himage) 
    {
        if (!is_string($himage))
        {
            return imagesx($himage);
        }
        list($imagew, $imageh) = getimagesize($himage);
        return $imagew;
    }
    
    function fetch_height($himage) 
    {
        if (!is_string($himage))
        {
            return imagesy($himage);
        }
        list($imagew, $imageh) = getimagesize($himage);
        return $imageh;
    }
    
    function fetch_image($url) 
    {
        if (substr($url, 0, 1) == "/")
        {
            $url = substr($url, 1, strlen($url) - 1);
        }
        $size = getimagesize($url);
        $mime = $size['mime'];
        if (strpos($mime, "jpeg") !== false)
        {
            $img = imagecreatefromjpeg($url);
        }
        elseif (strpos($mime, "png") !== false)
        {
            $img = imagecreatefrompng($url);
        }
        else
        {
            $img = imagecreatefromgif($url);
        }
        
        return $img;      
    }
    
    function fetch_image_from_string($string) 
    {
        return imagecreatefromstring($string);        
    }
    
    function output($himage, $filename) 
    {
        header('Cache-control: no-cache');
       	header('Expires: -1');
       	header('Content-disposition: inline; filename=' . $filename);
       	header('Content-transfer-encoding: binary');
       	header('Content-type: image/png');
        imagepng($himage);
    }
    
    function create_truecolor($imgwidth, $imgheight, $imgdst) 
    {
        $sprite = imagecreatetruecolor($imgwidth, $imgheight); 
        imagealphablending($sprite, false); 
        $transparent = imagecolorallocatealpha($sprite, 0, 0, 0, 127); 
        imagecolortransparent($sprite, $transparent); 
        imagefill($sprite, 0, 0, $transparent);
        imagecopy($sprite, $imgdst, 0, 0, 0, 0, $imgwidth, $imgheight);
        
        return $sprite;        
    }
    
    function load_egg($url) 
    {
        return imagecreatefromgif($url);        
    }
    
    function copy_image(&$hdst, $hsrc, $dstx, $dsty, $srcx, $srcy, $srcwidth, $srcheight) 
    {
        imagecopy($hdst, $hsrc, $dstx, $dsty, $srcx, $srcy, $srcwidth, $srcheight);
    }
    
    function destroy_image($himage) 
    {
        imagedestroy($himage);
    }
    
    function process_for_output($himage) 
    {
        imagealphablending($himage, true); 
        imagesavealpha($himage, true);
        return $himage;        
    }
}
?>